# INTEGRITY_GUIDE.md
## Distinguishing Accuracy from Integrity Issues in Conscious Capitalism Communications

### Recognition Hierarchy: Check This FIRST

Before analyzing any other dimension, scan the communication for **mixed motivations presented as pure service**. This is the most common and most serious integrity gap in CC communications.

**The pattern:**
- Claims pure service/altruism ("no strings," "just helping," "gift to community")  
- WHILE simultaneously positioning business offerings ("frameworks for other needs," "here are our services," "let's discuss partnership")

**Why it matters:** This pattern erodes trust at a values level because it makes stakeholders question whether stated motives are genuine.

**What to do when you spot it:**
1. Label it explicitly in Assessment Summary: "INTEGRITY TENSION: [describe the gap]"
2. Flag it in Values Consistency dimension with detailed explanation
3. Provide model sentence for resolution
4. Do NOT call it an accuracy issue—it's an integrity issue

**After checking for this pattern**, then evaluate other dimensions.

---

### The Critical Distinction

**ACCURACY ISSUES** are about whether claims are true or verifiable.
**INTEGRITY ISSUES** are about alignment between stated values and embedded signals.

In Conscious Capitalism review, integrity issues are MORE SERIOUS because they erode trust at a values level—they make stakeholders question whether the communicator means what they say about their values.

### Decision Framework

Ask yourself:
1. **Is this a factual claim that might not be true?** → Accuracy issue
2. **Is there a gap between stated values/motives and the signals being sent?** → Integrity issue
3. **Would this make stakeholders question the person's sincerity about their values?** → Integrity issue

### INTEGRITY ISSUES: 10 Clear Examples

**Example 1: "No Strings" While Positioning**
```
DRAFT: "No strings attached—I'm just here to help. By the way, if you need consulting services, here's our capabilities deck."

INTEGRITY GAP: Claims pure service ("no strings") while immediately offering paid services. The framing and the action contradict each other.

MODEL FIX: "I'm bringing this to support your work, AND I'm transparent that we'd value being a partner if that serves you. Both are true."
```

**Example 2: Gift Framing + Business Development**
```
DRAFT: "This is my gift to the community—I want nothing in return. P.S. Here are three other products we offer that might help."

INTEGRITY GAP: "Gift" framing + product catalog = mixed motivations disguised as pure generosity.

MODEL FIX: "I'm contributing this to the community. If it's valuable and you want to explore related work, I'm open to that conversation."
```

**Example 3: Stakeholder-First Language + Extractive Structure**
```
DRAFT: "We care deeply about all our stakeholders. That's why we're reducing benefits and increasing hours to protect shareholder value."

INTEGRITY GAP: Claims stakeholder orientation while prioritizing one stakeholder (shareholders) at others' expense.

MODEL FIX: "We're facing difficult tradeoffs. To preserve jobs and maintain operations, we're asking for temporary benefit adjustments and increased flexibility. Here's how we're sharing this burden across all stakeholder groups including leadership..."
```

**Example 4: "Just Helping" + Partnership Language**
```
DRAFT: "I'm just reaching out to be helpful. No agenda. Also, I think we'd make great strategic partners—let me know when we can discuss terms."

INTEGRITY GAP: "No agenda" claim immediately followed by partnership pitch.

MODEL FIX: "I'm reaching out because I think there's potential value here for both our organizations. Here's what I'm thinking..."
```

**Example 5: Transparency Claim + Opacity**
```
DRAFT: "We value radical transparency. For competitive reasons, we can't share details about the restructuring, timeline, or affected roles."

INTEGRITY GAP: Claims transparency as a value while withholding key information.

MODEL FIX: "We're committed to sharing what we can. Here's what we know now [specifics]. Here's what we're still determining [specifics]. Here's when we'll have more clarity [date]."
```

**Example 6: Purpose-Driven + Purely Transactional**
```
DRAFT: "Our purpose is elevating humanity through business. Now let's talk about maximizing Q4 revenue by cutting customer service costs."

INTEGRITY GAP: Purpose language disconnected from actual decision criteria.

MODEL FIX: "Our purpose is elevating humanity through business. In this decision about customer service, here's how we're balancing cost management with serving customers well..."
```

**Example 7: Trust-Building Claim + Defensive Tone**
```
DRAFT: "We're committed to building trust. Frankly, these complaints are unfair and show a misunderstanding of our situation. We won't address them further."

INTEGRITY GAP: Trust-building claim followed by defensiveness and dismissal.

MODEL FIX: "We're committed to building trust, which means hearing concerns even when they're hard to hear. Here's what we're learning from this feedback..."
```

**Example 8: Values Consistency + Blame**
```
DRAFT: "Integrity is our core value. This project failed because the team didn't execute properly and made poor choices."

INTEGRITY GAP: Claims integrity value while deflecting accountability and blaming team.

MODEL FIX: "Integrity is our core value, which means owning outcomes. This project didn't succeed. Here's what I could have done differently as the leader, and here's what we're learning..."
```

**Example 9: Human Dignity + Dehumanizing Language**
```
DRAFT: "We honor the humanity of every person. We're reducing headcount by 15% and eliminating non-essential resources in Q1."

INTEGRITY GAP: Human dignity claim + treating people as "headcount" and "resources."

MODEL FIX: "We honor the humanity of every person, which makes this decision painful. We're reducing our team by 15%—affecting people and families we care about..."
```

**Example 10: Altruistic Framing + Positioning for Sale**
```
DRAFT: "I'm offering this framework freely to serve the community—I want everyone to benefit. If you want the premium version with certification and ongoing support, here are our packages starting at $10K."

INTEGRITY GAP: "Freely" + "serve the community" framing immediately followed by upsell structure.

MODEL FIX: "I'm sharing the core framework freely so anyone can benefit. For organizations wanting structured implementation support, we offer facilitation and certification programs."
```

### ACCURACY ISSUES: 10 Clear Examples

These are NOT integrity issues—they're claims that may not be true or verifiable.

**Example 1: Universal Fit Claims**
```
DRAFT: "This works for every company in every industry."

ACCURACY ISSUE: Unverifiable universal claim. Many solutions don't work universally.

FIX: "This works well for companies with [specific characteristics]. We've seen success in [industries/contexts]."
```

**Example 2: Guaranteed Outcomes**
```
DRAFT: "You'll definitely see 50% improvement in engagement within 30 days."

ACCURACY ISSUE: Guaranteeing outcomes that depend on many variables.

FIX: "Organizations typically see 30-50% improvement in engagement within 60-90 days, though results vary based on starting point and implementation."
```

**Example 3: Competitive Superiority Claims**
```
DRAFT: "We're the best solution in the market."

ACCURACY ISSUE: Subjective, unverifiable claim.

FIX: "We're designed specifically for [use case] and excel at [specific capabilities]."
```

**Example 4: Absolute Time Claims**
```
DRAFT: "Implementation takes exactly 2 weeks, no exceptions."

ACCURACY ISSUE: Absolute claim likely not true across all contexts.

FIX: "Implementation typically takes 2-3 weeks, depending on team size and complexity."
```

**Example 5: Unsupported Statistics**
```
DRAFT: "Studies show that 89% of companies fail without this approach."

ACCURACY ISSUE: Vague "studies show" without citation; specific statistic without source.

FIX: "Research suggests companies with [specific practice] outperform peers, though success depends on many factors."
```

**Example 6: Oversimplified Causation**
```
DRAFT: "Using our tool will make your team happy and productive."

ACCURACY ISSUE: Oversimplified causation—many factors affect happiness and productivity.

FIX: "Our tool addresses common friction points that affect team productivity. Teams report improved workflow and reduced frustration."
```

**Example 7: Obsolete Information**
```
DRAFT: "Based on 2015 research, this approach works best."

ACCURACY ISSUE: Dated information presented as current guidance.

FIX: "Historical research (2015) suggested this approach. More recent developments may offer alternative perspectives worth exploring."
```

**Example 8: One-Size-Fits-All Methodology**
```
DRAFT: "Follow these exact 7 steps and you'll succeed."

ACCURACY ISSUE: Implies success is guaranteed by following steps, ignoring context.

FIX: "These 7 steps provide a framework. Adapt them to your specific context and organizational culture."
```

**Example 9: Universal Stakeholder Claim**
```
DRAFT: "All stakeholders love this approach."

ACCURACY ISSUE: Unlikely that all stakeholders have uniform response.

FIX: "This approach resonates particularly well with [specific stakeholders]. We've seen mixed responses from [other stakeholders] who prefer [alternative]."
```

**Example 10: Immediate Impact Claims**
```
DRAFT: "You'll see results instantly."

ACCURACY ISSUE: Very few interventions produce instant, measurable results.

FIX: "You'll see initial indicators within [timeframe], with full impact emerging over [longer timeframe]."
```

### Why Integrity Issues Are More Serious

**Accuracy issues** damage credibility when discovered, but can be corrected by updating information.

**Integrity issues** damage trust at a deeper level because they:
- Make stakeholders question motives and sincerity
- Create doubt about whether stated values are real
- Erode psychological safety (people wonder what else isn't as it seems)
- Violate Conscious Capitalism's core tenet of trust-building
- Take longer to repair—trust is rebuilt slowly

In Conscious Capitalism, we care deeply about both accuracy and integrity, but integrity gaps are the more serious values violation.

### Model Sentence for Mixed Motives

When you identify mixed motivations being presented as pure service, use this framework:

**"I'm [action] as [stated motive], AND I'm transparent that [actual business interest]. Both are true."**

Examples:
- "I'm offering this as a contribution to the movement, AND I'm transparent that we'd value partnership opportunities if they serve you. Both are true."
- "I'm reaching out to be helpful, AND I'm also exploring whether there's a fit for collaboration. Both are true."
- "I'm sharing this freely to serve the community, AND we also offer paid implementation support for those who want it. Both are true."

The key: Name BOTH truths explicitly instead of framing one while hiding the other.

### Quick Reference: Is This Integrity or Accuracy?

**Integrity Check Questions:**
- Is there a gap between what they claim to value and the signals they're sending?
- Would stakeholders question their sincerity about their stated values?
- Are mixed motivations being presented as pure motives?
- Do their words and actions contradict each other?

**Accuracy Check Questions:**
- Is this a factual claim that might not be true?
- Is this an overgeneralization or oversimplification?
- Is this guaranteed outcome realistic?
- Is this claim verifiable?

When in doubt, err on the side of calling it an integrity issue IF it relates to values alignment. The goal is surfacing values gaps, not fact-checking.
